/*
	icst.spline display companion using jsui/mgraphics 
	- replaces lcd-based version

	(c) 2021 ICST Zurich University of the Arts
	
	revision history:
	20210306 inital v1.0 
	
*/
autowatch=0,inlets=3,outlets=2,mgraphics.init(),mgraphics.relative_coords=1,mgraphics.autofill=0;var task=new Task(load_sync_external_task,this);function Point(){this.x=0,this.y=0,this.z=0}function Rectangle(){this.x1=0,this.y1=0,this.x2=0,this.y2=0}var bgcolor=[0,.125,.25,1],splinecolor=[.75,.9,1,.8],polygoncolor=[1,1,1,.3],handlecolor0=[.3,1,.9,.75],handlecolor1=[.3,.9,1,.75],pointcolor=[1,.5,0,1],textcolor=[1,1,1,.5],markercolor=[1,1,0,1],gridcolor=[1,1,1,.075],labelcolor=[1,1,1,.25],boundingboxcolor=[1,.75,.66,.35],centroidcolor=[.4,.8,1,.6666],pointSizePX=8,pointSize=8,searchRadiusPX=10,searchRadius,hitPointID,haveHit,splineClosed=1,autoHandles=0,snapToGrid=0,showHandles=0,showMarker=1,showPoints=1,showPoly=1,showSpline=1,showGrid=1,showAxes=1,showLabel=1,showBox=1,showCentroid=1,readMode,markerPosition=new Point,markerStoredFlag=0,markerInputFloat,worldMouse=new Point,storedMouse=new Point,gWidth,gHeight,gAspect,gOneOverHalfHeight,polygon=new Array,polyCount=0,spline=new Array,splineCount=0,newSplineFlag=1,handle=new Array,pt1=new Point;handle[0]=pt1;var pt2=new Point;handle[1]=pt2;var initialViewOffset=new Point;initialViewOffset.x=0,initialViewOffset.y=0;var viewTranslate=new Point;viewTranslate.x=0,viewTranslate.y=0;var initialViewScale=1,viewScale=1,oneOverViewScale=.1,viewMode=0,funcViewScale=new Point;funcViewScale.x=.95,funcViewScale.y=.95;var gridStep=10,viewRect=new Rectangle,unitLineStart_x,unitLineStart_y,numUnitLines_x,numUnitLines_y,fineLineStart_x,fineLineStart_y,numFineLines_x,numFineLines_y,originPX=new Point,worldPX=new Point,labelPosition=new Point,gBoxMin=new Point,gBoxMax=new Point,gBoxCenter=new Point,gCentroid=new Point,gEye=new Point,gPoi=new Point,gRange=new Point,gViewCoords=new Point,gSize=new Rectangle,gOrbit=new Point,gStoredOrbit=new Point,viewTranslate3D=new Point;viewTranslate3D.x=0,viewTranslate3D.y=0,viewTranslate3D.z=0;var translateScaleView=new Array,gSinPitch,gCosPitch,gSinYaw,gCosYaw,gSinRoll,gCosRoll,gFov,gRatio,gFov2,gFov2V,gProjectionDistance,gPitch,gYaw,gRoll,gMode,gInRangeFlag,pi=3.141592653589793,half_pi=.5*pi,two_pi=2*pi,divide_two_pi=1/two_pi,degtorad=pi/180,polyScale=new Point,polyTranslate=new Point,polyRotate=new Point,rotationQuat=new Array(4),presetDict=new Dict;function init(){reset_3D_view(),gridSpacing=1/gridStep,calcAspect(),calcPointSize(),calcViewRect();for(var e=0;e<5;e++)translateScaleView[e]=new Point,translateScaleView[e].x=0,translateScaleView[e].y=0,translateScaleView[e].z=1;translateScaleView[4].x=0,translateScaleView[4].y=0,translateScaleView[4].z=0,funcViewScale.x=.95,funcViewScale.y=.95,gOrbit.x=-30,gOrbit.y=30,gOrbit.z=4,gEye.x=-1.732050807568879,gEye.y=2,gEye.z=3,update(),polyScale.x=polyScale.y=polyScale.z=1,presetDict.name="icst.spline_editor.presets",funcViewScale.y=.94,funcViewScale.y=.96}function bang(){var e=this.inlet;0==e?mgraphics.redraw():1!=e&&2!=e||(newSplineFlag=1)}function msg_float(e){var o=this.inlet;0==o?viewMode<=3?(markerInputFloat=e,markerStoredFlag=1):4==viewMode&&(markerPosition.x=e,markerStoredFlag=1,mgraphics.redraw()):(o=1)&&(markerInputFloat=e,markerStoredFlag=1,mgraphics.redraw())}function list(){var e=arrayfromargs(messagename,arguments),o=this.inlet;if(0==o)if(0==markerStoredFlag){if(1==newSplineFlag&&(splineCount=0,resetBoundingBox(),newSplineFlag=0),3==e.length){if(null==spline[splineCount]){var i=new Point;spline[splineCount]=i}spline[splineCount].x=e[0],spline[splineCount].y=e[1],spline[splineCount].z=e[2],calcBoundingBox(spline[splineCount].x,spline[splineCount].y,spline[splineCount].z),splineCount++}markerInputFloat=0}else 1==markerStoredFlag&&(markerPosition.x=e[0],markerPosition.y=e[1],markerPosition.z=e[2],markerStoredFlag=0);else if(1==o){polyCount=0,splineCount=0,resetBoundingBox();for(var t=0;t<e.length/3;t++){if(null==polygon[t]){i=new Point;polygon.push(i)}polygon[t].x=e[3*t],polygon[t].y=e[3*t+1],polygon[t].z=e[3*t+2],polyCount++,calcPolyCentroid()}markerPosition.x=polygon[0].x,markerPosition.y=polygon[0].y,markerPosition.z=polygon[0].z,1==autoHandles&&make_handles(),markerInputFloat=0}mgraphics.redraw()}function paint(){var i,j,k;with(mgraphics)set_source_rgba(bgcolor),rectangle(-1*gAspect-.01,1.01,gWidth+.01,gHeight+.01),fill(),viewMode<3?(translate(viewTranslate.x,viewTranslate.y),paint_grid(),paint_axes(),paint_polygon(),paint_centroid(),paint_handles(),paint_spline(),paint_points(),paint_marker(),paint_label(),identity_matrix()):3==viewMode?(translate(-viewTranslate.x,-viewTranslate.y),paint_grid3D(),paint_axes3D(),paint_polygon3D(),paint_handles3D(),paint_box3D(),paint_centroid3D(),paint_spline3D(),paint_points3D(),paint_marker3D(),identity_matrix()):4==viewMode&&(translate(viewTranslate.x,viewTranslate.y),paint_grid_func(),paint_polygon_func(),paint_box_func(),paint_handles_func(),paint_spline_func(),paint_points_func(),paint_marker_func(),paint_label_func(),identity_matrix())}function paint_grid(){if(1==showGrid&&viewMode<3){for(mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],1.5*gridcolor[3]),i=0;i<numUnitLines_x;i++)mgraphics.move_to(unitLineStart_x+i*viewScale,viewRect.y1),mgraphics.line_to(unitLineStart_x+i*viewScale,viewRect.y2),mgraphics.stroke();for(i=0;i<numUnitLines_y;i++)mgraphics.move_to(viewRect.x1,unitLineStart_y+i*viewScale),mgraphics.line_to(viewRect.x2,unitLineStart_y+i*viewScale),mgraphics.stroke();var e=1.31666666*viewScale-.316666;if((e=clip(e,0,1))>0){for(mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*e),i=0;i<numFineLines_x;i++)mgraphics.move_to(fineLineStart_x+i*gridSpacing*viewScale,viewRect.y1),mgraphics.line_to(fineLineStart_x+i*gridSpacing*viewScale,viewRect.y2),mgraphics.stroke();for(i=0;i<numFineLines_y;i++)mgraphics.move_to(viewRect.x1,fineLineStart_y+i*gridSpacing*viewScale),mgraphics.line_to(viewRect.x2,fineLineStart_y+i*gridSpacing*viewScale),mgraphics.stroke()}}}function paint_axes(){showAxes&&(mgraphics.select_font_face("Arial"),mgraphics.set_font_size(11),0!=viewMode&&1!=viewMode||(mgraphics.set_source_rgba(1,.2,.2,.7),originPX.y>0&&originPX.y<gHeight&&(mgraphics.move_to(viewRect.x1,0),mgraphics.line_to(viewRect.x2,0),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(viewRect.x2-.0888,.02),mgraphics.show_text("+x")))),0==viewMode?(mgraphics.set_source_rgba(0,.7,0,.5),originPX.x>0&&originPX.x<gWidth&&(mgraphics.move_to(0,viewRect.y1),mgraphics.line_to(0,viewRect.y2),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(.01,viewRect.y1-.05555),mgraphics.show_text("+y")))):2==viewMode&&(mgraphics.set_source_rgba(0,.7,0,.5),originPX.y>0&&originPX.y<gHeight&&(mgraphics.move_to(viewRect.x1,0),mgraphics.line_to(viewRect.x2,0),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(viewRect.x2-.0888,.02),mgraphics.show_text("+y")))),1!=viewMode&&2!=viewMode||(mgraphics.set_source_rgba(.5,.5,1,.5),originPX.x>0&&originPX.x<gWidth&&(mgraphics.move_to(0,viewRect.y1),mgraphics.line_to(0,viewRect.y2),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(.01,viewRect.y1-.05555),mgraphics.show_text("+z")))))}function paint_polygon(){if(1==showPoly&&polyCount>0&&(mgraphics.set_source_rgba(polygoncolor),polyCount>0)){if(0==viewMode)for(mgraphics.move_to(polygon[0].x*viewScale,polygon[0].y*viewScale),j=1;j<polyCount;j++)mgraphics.line_to(polygon[j].x*viewScale,polygon[j].y*viewScale);else if(1==viewMode)for(mgraphics.move_to(polygon[0].x*viewScale,polygon[0].z*viewScale),j=1;j<polyCount;j++)mgraphics.line_to(polygon[j].x*viewScale,polygon[j].z*viewScale);else if(2==viewMode)for(mgraphics.move_to(polygon[0].y*viewScale,polygon[0].z*viewScale),j=1;j<polyCount;j++)mgraphics.line_to(polygon[j].y*viewScale,polygon[j].z*viewScale);splineClosed&&mgraphics.close_path(),mgraphics.stroke()}}function paint_handles(){1==showHandles&&polyCount>0&&(mgraphics.select_font_face("Arial"),mgraphics.set_font_size(11),mgraphics.set_source_rgba(handlecolor0),0==viewMode?(mgraphics.move_to(polygon[0].x*viewScale,polygon[0].y*viewScale),mgraphics.line_to(handle[0].x*viewScale,handle[0].y*viewScale),mgraphics.stroke(),mgraphics.rectangle(handle[0].x*viewScale-.3*pointSize,handle[0].y*viewScale+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(handle[0].x*viewScale-2.75*pointSize,handle[0].y*viewScale-.25*pointSize),mgraphics.show_text("h0")),mgraphics.set_source_rgba(handlecolor1),mgraphics.move_to(polygon[polyCount-1].x*viewScale,polygon[polyCount-1].y*viewScale),mgraphics.line_to(handle[1].x*viewScale,handle[1].y*viewScale),mgraphics.stroke(),mgraphics.rectangle(handle[1].x*viewScale-.3*pointSize,handle[1].y*viewScale+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(handle[1].x*viewScale-2.75*pointSize,handle[1].y*viewScale-.25*pointSize),mgraphics.show_text("h1"))):1==viewMode?(mgraphics.move_to(polygon[0].x*viewScale,polygon[0].z*viewScale),mgraphics.line_to(handle[0].x*viewScale,handle[0].z*viewScale),mgraphics.stroke(),mgraphics.rectangle(handle[0].x*viewScale-.3*pointSize,handle[0].z*viewScale+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(handle[0].x*viewScale-2.75*pointSize,handle[0].z*viewScale-.25*pointSize),mgraphics.show_text("h0")),mgraphics.set_source_rgba(handlecolor1),mgraphics.move_to(polygon[polyCount-1].x*viewScale,polygon[polyCount-1].z*viewScale),mgraphics.line_to(handle[1].x*viewScale,handle[1].z*viewScale),mgraphics.stroke(),mgraphics.rectangle(handle[1].x*viewScale-.3*pointSize,handle[1].z*viewScale+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(handle[1].x*viewScale-2.75*pointSize,handle[1].z*viewScale-.25*pointSize),mgraphics.show_text("h1"))):2==viewMode&&(mgraphics.move_to(polygon[0].y*viewScale,polygon[0].z*viewScale),mgraphics.line_to(handle[0].y*viewScale,handle[0].z*viewScale),mgraphics.stroke(),mgraphics.rectangle(handle[0].y*viewScale-.3*pointSize,handle[0].z*viewScale+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(handle[0].y*viewScale-2.75*pointSize,handle[0].z*viewScale-.25*pointSize),mgraphics.show_text("h0")),mgraphics.set_source_rgba(handlecolor1),mgraphics.move_to(polygon[polyCount-1].y*viewScale,polygon[polyCount-1].z*viewScale),mgraphics.line_to(handle[1].y*viewScale,handle[1].z*viewScale),mgraphics.stroke(),mgraphics.rectangle(handle[1].y*viewScale-.3*pointSize,handle[1].z*viewScale+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(handle[1].y*viewScale-2.75*pointSize,handle[1].z*viewScale-.25*pointSize),mgraphics.show_text("h1"))))}function paint_spline(){if(1==showSpline&&splineCount>0&&(mgraphics.set_source_rgba(splinecolor),splineCount>0)){if(0==viewMode)for(mgraphics.move_to(spline[0].x*viewScale,spline[0].y*viewScale),j=1;j<splineCount;j++)null!=spline[j]&&mgraphics.line_to(spline[j].x*viewScale,spline[j].y*viewScale);else if(1==viewMode)for(mgraphics.move_to(spline[0].x*viewScale,spline[0].z*viewScale),j=1;j<splineCount;j++)null!=spline[j]&&mgraphics.line_to(spline[j].x*viewScale,spline[j].z*viewScale);else if(2==viewMode)for(mgraphics.move_to(spline[0].y*viewScale,spline[0].z*viewScale),j=1;j<splineCount;j++)null!=spline[j]&&mgraphics.line_to(spline[j].y*viewScale,spline[j].z*viewScale);mgraphics.stroke(),splineClosed&&mgraphics.close_path()}}function paint_points(){if(1==showPoints&&polyCount>0){if(mgraphics.set_source_rgba(pointcolor),polyCount>0)for(k=0;k<polyCount;k++)0==viewMode?mgraphics.ellipse(polygon[k].x*viewScale-.5*pointSize,polygon[k].y*viewScale+.5*pointSize,pointSize,pointSize):1==viewMode?mgraphics.ellipse(polygon[k].x*viewScale-.5*pointSize,polygon[k].z*viewScale+.5*pointSize,pointSize,pointSize):2==viewMode&&mgraphics.ellipse(polygon[k].y*viewScale-.5*pointSize,polygon[k].z*viewScale+.5*pointSize,pointSize,pointSize),hitPointID==k?mgraphics.fill():mgraphics.stroke();if(1==showLabel&&polyCount>0)for(mgraphics.set_source_rgba(textcolor),mgraphics.select_font_face("Arial"),mgraphics.set_font_size(11),j=0;j<polyCount;j++)0==viewMode?mgraphics.move_to(polygon[j].x*viewScale+.75*pointSize,polygon[j].y*viewScale-.25*pointSize):1==viewMode?mgraphics.move_to(polygon[j].x*viewScale+.75*pointSize,polygon[j].z*viewScale-.25*pointSize):2==viewMode&&mgraphics.move_to(polygon[j].y*viewScale+.75*pointSize,polygon[j].z*viewScale-.25*pointSize),mgraphics.show_text(j.toString())}}function paint_marker(){1==showMarker&&polyCount>0&&(mgraphics.set_source_rgba(markercolor),0==viewMode?(mgraphics.move_to(markerPosition.x*viewScale,markerPosition.y*viewScale+.707107*pointSize),mgraphics.line_to(markerPosition.x*viewScale+.707107*pointSize,markerPosition.y*viewScale),mgraphics.line_to(markerPosition.x*viewScale,markerPosition.y*viewScale-.707107*pointSize),mgraphics.line_to(markerPosition.x*viewScale-.707107*pointSize,markerPosition.y*viewScale),mgraphics.line_to(markerPosition.x*viewScale,markerPosition.y*viewScale+.707107*pointSize)):1==viewMode?(mgraphics.move_to(markerPosition.x*viewScale,markerPosition.z*viewScale+.707107*pointSize),mgraphics.line_to(markerPosition.x*viewScale+.707107*pointSize,markerPosition.z*viewScale),mgraphics.line_to(markerPosition.x*viewScale,markerPosition.z*viewScale-.707107*pointSize),mgraphics.line_to(markerPosition.x*viewScale-.707107*pointSize,markerPosition.z*viewScale),mgraphics.line_to(markerPosition.x*viewScale,markerPosition.z*viewScale+.707107*pointSize)):2==viewMode&&(mgraphics.move_to(markerPosition.y*viewScale,markerPosition.z*viewScale+.707107*pointSize),mgraphics.line_to(markerPosition.y*viewScale+.707107*pointSize,markerPosition.z*viewScale),mgraphics.line_to(markerPosition.y*viewScale,markerPosition.z*viewScale-.707107*pointSize),mgraphics.line_to(markerPosition.y*viewScale-.707107*pointSize,markerPosition.z*viewScale),mgraphics.line_to(markerPosition.y*viewScale,markerPosition.z*viewScale+.707107*pointSize)),mgraphics.stroke())}function paint_label(){1==showLabel&&(mgraphics.set_source_rgba(labelcolor),mgraphics.set_font_size(10),mgraphics.select_font_face("Arial"),mgraphics.move_to(labelPosition.x,labelPosition.y),0==viewMode?mgraphics.show_text("xy-view"):1==viewMode?mgraphics.show_text("xz-view"):2==viewMode&&mgraphics.show_text("yz-view"))}function paint_centroid(){if(1==showCentroid&&polyCount>0){var e=new Point;0==viewMode?(e.x=gCentroid.x*viewScale,e.y=gCentroid.y*viewScale):1==viewMode?(e.x=gCentroid.x*viewScale,e.y=gCentroid.z*viewScale):2==viewMode&&(e.x=gCentroid.y*viewScale,e.y=gCentroid.z*viewScale),mgraphics.set_source_rgba(centroidcolor),mgraphics.rectangle(e.x-.35*pointSize,e.y+.35*pointSize,.7*pointSize,.7*pointSize),mgraphics.stroke(),mgraphics.move_to(e.x-pointSize,e.y),mgraphics.line_to(e.x-.35*pointSize,e.y),mgraphics.move_to(e.x+pointSize,e.y),mgraphics.line_to(e.x+.35*pointSize,e.y),mgraphics.move_to(e.x,e.y-pointSize),mgraphics.line_to(e.x,e.y-.35*pointSize),mgraphics.move_to(e.x,e.y+pointSize),mgraphics.line_to(e.x,e.y+.35*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.select_font_face("Arial"),mgraphics.set_font_size(9),mgraphics.move_to(e.x+pointSize,e.y),mgraphics.show_text("C"))}}function paint_grid3D(){if(1==showGrid){var e=.707106781187*gOrbit.z,o=Math.floor(e),i=new Point,t=mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],.5*gridcolor[3]);i=project_3D(-e,0,0),mgraphics.move_to(i.x,i.y),i=project_3D(e,0,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(0,-e,0),mgraphics.move_to(i.x,i.y),i=project_3D(0,e,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],.75*gridcolor[3]);for(var n=Math.floor(e)+1,l=0;l<n;l++){var r=1*l;i=project_3D(-e,l,0),mgraphics.move_to(i.x,i.y),i=project_3D(e,l,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(l,-e,0),mgraphics.move_to(i.x,i.y),i=project_3D(l,e,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(-e,-l,0),mgraphics.move_to(i.x,i.y),i=project_3D(e,-l,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(-l,-e,0),mgraphics.move_to(i.x,i.y),i=project_3D(-l,e,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke()}if(o<=6){t=1-clip(e-5,0,1);mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],.75*gridcolor[3]*t);for(n=Math.floor(2*e)+1,l=0;l<n;l++){i=project_3D(-e,r=.5*l,0),mgraphics.move_to(i.x,i.y),i=project_3D(e,r,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(r,-e,0),mgraphics.move_to(i.x,i.y),i=project_3D(r,e,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(-e,-r,0),mgraphics.move_to(i.x,i.y),i=project_3D(e,-r,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(-r,-e,0),mgraphics.move_to(i.x,i.y),i=project_3D(-r,e,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke()}if(o<=4){t=1-clip(1*(.707106781187*gOrbit.z-3),0,1);mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],.75*gridcolor[3]*t);for(n=Math.floor(10*e)+1,l=0;l<n;l++){i=project_3D(-e,r=.1*l,0),mgraphics.move_to(i.x,i.y),i=project_3D(e,r,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(r,-e,0),mgraphics.move_to(i.x,i.y),i=project_3D(r,e,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(-e,-r,0),mgraphics.move_to(i.x,i.y),i=project_3D(e,-r,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke(),i=project_3D(-r,-e,0),mgraphics.move_to(i.x,i.y),i=project_3D(-r,e,0),mgraphics.line_to(i.x,i.y),mgraphics.stroke()}}}}}function paint_axes3D(){if(1==showAxes){new Point;var e=1;.707106781187*gOrbit.z<=1&&(e=.707106781187*gOrbit.z),mgraphics.set_font_size(10),mgraphics.select_font_face("Arial"),mgraphics.set_source_rgba(1,.2,.2,.7),tmp=project_3D(-e,0,0),mgraphics.move_to(tmp.x,tmp.y),tmp=project_3D(e,0,0),mgraphics.line_to(tmp.x,tmp.y),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(tmp.x,tmp.y),mgraphics.show_text("+x")),mgraphics.set_source_rgba(0,.7,0,.5),tmp=project_3D(0,-e,0),mgraphics.move_to(tmp.x,tmp.y),tmp=project_3D(0,e,0),mgraphics.line_to(tmp.x,tmp.y),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(tmp.x,tmp.y),mgraphics.show_text("+y")),mgraphics.set_source_rgba(.5,.5,1,.5),tmp=project_3D(0,0,-e),mgraphics.move_to(tmp.x,tmp.y),tmp=project_3D(0,0,e),mgraphics.line_to(tmp.x,tmp.y),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(tmp.x,tmp.y),mgraphics.show_text("+z"))}}function paint_poi3D(){var e=new Point;mgraphics.set_source_rgba(1,8,.2,1),e=project_3D(-gPoi.x,-gPoi.y,gPoi.z),mgraphics.move_to(e.x,e.y),mgraphics.ellipse(e.x*viewScale-.5*pointSize,e.y*viewScale+.5*pointSize,pointSize,pointSize),mgraphics.stroke()}function paint_handles3D(){var e=new Point;1==showHandles&&polyCount>0&&(mgraphics.select_font_face("Arial"),mgraphics.set_font_size(11),mgraphics.set_source_rgba(handlecolor0),e=project_3D(polygon[0].x,polygon[0].y,polygon[0].z),mgraphics.move_to(e.x,e.y),e=project_3D(handle[0].x,handle[0].y,handle[0].z),mgraphics.line_to(e.x,e.y),mgraphics.stroke(),mgraphics.rectangle(e.x-.25*pointSize,e.y+.25*pointSize,.5*pointSize,.5*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(e.x-2.75*pointSize,e.y-.25*pointSize),mgraphics.show_text("h0")),mgraphics.set_source_rgba(handlecolor1),e=project_3D(polygon[polyCount-1].x,polygon[polyCount-1].y,polygon[polyCount-1].z),mgraphics.move_to(e.x,e.y),e=project_3D(handle[1].x,handle[1].y,handle[1].z),mgraphics.line_to(e.x,e.y),mgraphics.stroke(),mgraphics.rectangle(e.x-.25*pointSize,e.y+.25*pointSize,.5*pointSize,.5*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(e.x-2.75*pointSize,e.y-.25*pointSize),mgraphics.show_text("h1")))}function paint_spline3D(){var e=new Point;if(1==showSpline&&splineCount>0&&splineCount>0){for(mgraphics.set_source_rgba(splinecolor),e=project_3D(spline[0].x,spline[0].y,spline[0].z),mgraphics.move_to(e.x,e.y),j=1;j<splineCount;j++)null!=spline[j]&&(e=project_3D(spline[j].x,spline[j].y,spline[j].z),mgraphics.line_to(e.x,e.y));mgraphics.stroke(),splineClosed&&mgraphics.close_path()}}function paint_polygon3D(){var e=new Point;if(1==showPoly&&polyCount>0){for(mgraphics.set_source_rgba(polygoncolor),e=project_3D(polygon[0].x,polygon[0].y,polygon[0].z),mgraphics.move_to(e.x,e.y),j=1;j<polyCount;j++)e=project_3D(polygon[j].x,polygon[j].y,polygon[j].z),mgraphics.line_to(e.x,e.y);splineClosed&&mgraphics.close_path(),mgraphics.stroke()}}function paint_points3D(){var e=new Point;if(1==showPoints&&polyCount>0){if(mgraphics.set_source_rgba(pointcolor),polyCount>0)for(k=0;k<polyCount;k++)e=project_3D(polygon[k].x,polygon[k].y,polygon[k].z),mgraphics.ellipse(e.x-.25*pointSize,e.y+.25*pointSize,.5*pointSize,.5*pointSize),hitPointID==k?mgraphics.fill():mgraphics.stroke();if(polyCount>0&&1==showLabel)for(mgraphics.set_source_rgba(textcolor),mgraphics.select_font_face("Arial"),mgraphics.set_font_size(11),j=0;j<polyCount;j++)e=project_3D(polygon[j].x,polygon[j].y,polygon[j].z),mgraphics.move_to(e.x+.375*pointSize,e.y-.125*pointSize),mgraphics.show_text(j.toString())}}function paint_marker3D(){if(1==showMarker&&polyCount>0){var e=new Point;e=project_3D(markerPosition.x,markerPosition.y,markerPosition.z),mgraphics.set_source_rgba(markercolor),mgraphics.move_to(e.x,e.y+.35*pointSize),mgraphics.line_to(e.x+.35*pointSize,e.y),mgraphics.line_to(e.x,e.y-.35*pointSize),mgraphics.line_to(e.x-.35*pointSize,e.y),mgraphics.line_to(e.x,e.y+.35*pointSize),mgraphics.stroke()}}function paint_box3D(){if(1==showBox&&polyCount>0){var e=new Point;mgraphics.set_source_rgba(boundingboxcolor),e=project_3D(gBoxMin.x,gBoxMin.y,gBoxMin.z),mgraphics.move_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMax.y,gBoxMin.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMax.y,gBoxMin.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMin.y,gBoxMin.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMin.y,gBoxMin.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMin.y,gBoxMax.z),mgraphics.move_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMax.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMax.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMin.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMin.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMin.y,gBoxMin.z),mgraphics.move_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMin.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMax.y,gBoxMin.z),mgraphics.move_to(e.x,e.y),e=project_3D(gBoxMin.x,gBoxMax.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMin.y,gBoxMin.z),mgraphics.move_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMin.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMax.y,gBoxMin.z),mgraphics.move_to(e.x,e.y),e=project_3D(gBoxMax.x,gBoxMax.y,gBoxMax.z),mgraphics.line_to(e.x,e.y),mgraphics.stroke()}}function paint_centroid3D(){1==showCentroid&&polyCount>0&&(mgraphics.set_source_rgba(centroidcolor),tmp=project_3D(gCentroid.x,gCentroid.y,gCentroid.z),mgraphics.rectangle(tmp.x-.25*pointSize,tmp.y+.25*pointSize,.5*pointSize,.5*pointSize),mgraphics.stroke(),mgraphics.move_to(tmp.x-.7*pointSize,tmp.y),mgraphics.line_to(tmp.x-.25*pointSize,tmp.y),mgraphics.move_to(tmp.x+.7*pointSize,tmp.y),mgraphics.line_to(tmp.x+.25*pointSize,tmp.y),mgraphics.move_to(tmp.x,tmp.y-.7*pointSize),mgraphics.line_to(tmp.x,tmp.y-.25*pointSize),mgraphics.move_to(tmp.x,tmp.y+.7*pointSize),mgraphics.line_to(tmp.x,tmp.y+.25*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.select_font_face("Arial"),mgraphics.set_font_size(9),mgraphics.move_to(tmp.x+pointSize,tmp.y),mgraphics.show_text("C")))}function paint_grid_func(){var e=new Point;if(1==showGrid){mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],2*gridcolor[3]),e=funcToWorld(0,1),mgraphics.move_to(e.x*funcViewScale.x,1+viewTranslate.y),mgraphics.line_to(e.x*funcViewScale.x,-1+viewTranslate.y),mgraphics.move_to(-gAspect-viewTranslate.x,e.y*funcViewScale.y),mgraphics.line_to(gAspect-viewTranslate.x,e.y*funcViewScale.y),mgraphics.stroke(),e=funcToWorld(1,0),mgraphics.move_to(e.x*funcViewScale.x,1+viewTranslate.y),mgraphics.line_to(e.x*funcViewScale.x,-1+viewTranslate.y),mgraphics.move_to(-gAspect-viewTranslate.x,e.y*funcViewScale.y),mgraphics.line_to(gAspect-viewTranslate.x,e.y*funcViewScale.y),mgraphics.stroke(),mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]);var o=1.1666666*funcViewScale.x-.16666;if((o=clip(o,0,1))>0)for(mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*o),i=0;i<numFineLines_x;i++)e=funcToWorld(i*gridSpacing,0),mgraphics.move_to(e.x*funcViewScale.x,e.y*funcViewScale.y),e=funcToWorld(i*gridSpacing,1),mgraphics.line_to(e.x*funcViewScale.x,e.y*funcViewScale.y),mgraphics.stroke();if((o=clip(o=1.1666666*funcViewScale.y-.16666,0,1))>0)for(mgraphics.set_source_rgba(gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]*o),i=0;i<numFineLines_x;i++)e=funcToWorld(0,i*gridSpacing),mgraphics.move_to(e.x*funcViewScale.x,e.y*funcViewScale.y),e=funcToWorld(1,i*gridSpacing),mgraphics.line_to(e.x*funcViewScale.x,e.y*funcViewScale.y),mgraphics.stroke()}}function paint_axes_func(){showAxes&&(mgraphics.select_font_face("Arial"),mgraphics.set_font_size(10),1==showLabel&&(mgraphics.set_source_rgba(1,.2,.2,.7),mgraphics.move_to(funcViewScale.x*-gAspect+.04,-funcViewScale.y-.045),mgraphics.show_text("0"),mgraphics.move_to(funcViewScale.x*gAspect-.04,-funcViewScale.y-.045),mgraphics.show_text("x1")),1==showLabel&&(mgraphics.set_source_rgba(0,.7,0,.5),mgraphics.move_to(funcViewScale.x*-gAspect-.03,.04-funcViewScale.y),mgraphics.show_text("0"),mgraphics.move_to(funcViewScale.x*-gAspect-.06,funcViewScale.y-.045),mgraphics.show_text("y1")))}function paint_polygon_func(){if(1==showPoly&&polyCount>0&&(mgraphics.set_source_rgba(polygoncolor),polyCount>0)){var e=funcToWorld(polygon[0].x,polygon[0].y);for(mgraphics.move_to(e.x*funcViewScale.x,e.y*funcViewScale.y),j=1;j<polyCount;j++){e=funcToWorld(polygon[j].x,polygon[j].y);mgraphics.line_to(e.x*funcViewScale.x,e.y*funcViewScale.y)}splineClosed&&mgraphics.close_path(),mgraphics.stroke()}}function paint_handles_func(){if(1==showHandles&&polyCount>0){mgraphics.select_font_face("Arial"),mgraphics.set_font_size(11),mgraphics.set_source_rgba(handlecolor0);var e=funcToWorld(polygon[0].x,polygon[0].y);mgraphics.move_to(e.x*funcViewScale.x,e.y*funcViewScale.y),e=funcToWorld(handle[0].x,handle[0].y),mgraphics.line_to(e.x*funcViewScale.x,e.y*funcViewScale.y),mgraphics.stroke(),mgraphics.rectangle(e.x*funcViewScale.x-.3*pointSize,e.y*funcViewScale.y+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(e.x*funcViewScale.x-2.75*pointSize,e.y*funcViewScale.y-.25*pointSize),mgraphics.show_text("h0")),mgraphics.set_source_rgba(handlecolor1),e=funcToWorld(polygon[polyCount-1].x,polygon[polyCount-1].y),mgraphics.move_to(e.x*funcViewScale.x,e.y*funcViewScale.y),e=funcToWorld(handle[1].x,handle[1].y),mgraphics.line_to(e.x*funcViewScale.x,e.y*funcViewScale.y),mgraphics.stroke(),mgraphics.rectangle(e.x*funcViewScale.x-.3*pointSize,e.y*funcViewScale.y+.3*pointSize,.6*pointSize,.6*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.move_to(e.x*funcViewScale.x-2.75*pointSize,e.y*funcViewScale.y-.25*pointSize),mgraphics.show_text("h1"))}}function paint_spline_func(){if(1==showSpline&&splineCount>0&&(mgraphics.set_source_rgba(splinecolor),splineCount>0)){var e=funcToWorld(spline[0].x,spline[0].y);for(mgraphics.move_to(e.x*funcViewScale.x,e.y*funcViewScale.y),j=1;j<splineCount;j++)null!=spline[j]&&(e=funcToWorld(spline[j].x,spline[j].y),mgraphics.line_to(e.x*funcViewScale.x,e.y*funcViewScale.y));mgraphics.stroke(),splineClosed&&mgraphics.close_path()}}function paint_points_func(){if(1==showPoints&&polyCount>0){if(mgraphics.set_source_rgba(pointcolor),polyCount>0)for(k=0;k<polyCount;k++){var e=funcToWorld(polygon[k].x,polygon[k].y);mgraphics.ellipse(e.x*funcViewScale.x-.5*pointSize,e.y*funcViewScale.y+.5*pointSize,pointSize,pointSize),hitPointID==k?mgraphics.fill():mgraphics.stroke()}if(1==showLabel&&polyCount>0)for(mgraphics.set_source_rgba(textcolor),mgraphics.select_font_face("Arial"),mgraphics.set_font_size(11),j=0;j<polyCount;j++){e=funcToWorld(polygon[j].x,polygon[j].y);mgraphics.move_to(e.x*funcViewScale.x+.75*pointSize,e.y*funcViewScale.y-.25*pointSize),mgraphics.show_text(j.toString())}}}function paint_marker_func(){var e=.707107*pointSize;if(1==showMarker&&polyCount>0)if(mgraphics.set_source_rgba(markercolor),0==readMode){var o=funcToWorld(markerPosition.x,markerPosition.y);mgraphics.move_to(o.x*funcViewScale.x,o.y*funcViewScale.y+e),mgraphics.line_to(o.x*funcViewScale.x+e,o.y*funcViewScale.y),mgraphics.line_to(o.x*funcViewScale.x,o.y*funcViewScale.y-e),mgraphics.line_to(o.x*funcViewScale.x-e,o.y*funcViewScale.y),mgraphics.line_to(o.x*funcViewScale.x,o.y*funcViewScale.y+e),mgraphics.stroke()}else if(1==readMode){o=funcToWorld(i=clip(markerInputFloat,0,1),markerPosition.x);mgraphics.move_to(o.x*funcViewScale.x+e,o.y*funcViewScale.y),mgraphics.line_to(o.x*funcViewScale.x-e,o.y*funcViewScale.y),mgraphics.stroke(),mgraphics.move_to(o.x*funcViewScale.x,o.y*funcViewScale.y-e),mgraphics.line_to(o.x*funcViewScale.x,o.y*funcViewScale.y+e),mgraphics.stroke(),mgraphics.set_source_rgba(1,1,1,.15*markercolor[3]),o=funcToWorld(0,markerPosition.x),mgraphics.move_to(o.x*funcViewScale.x,o.y*funcViewScale.y),o=funcToWorld(markerInputFloat,markerPosition.x),mgraphics.line_to(o.x*funcViewScale.x,o.y*funcViewScale.y),mgraphics.stroke(),1==showLabel&&(mgraphics.set_source_rgba(1,1,1,.5*markercolor[3]),o=funcToWorld(0,markerPosition.x),mgraphics.move_to(o.x*funcViewScale.x+.25*pointSize,o.y*funcViewScale.y-.35*pointSize),mgraphics.show_text(markerPosition.x.toFixed(2)))}else if(2==readMode){var i=clip(markerInputFloat,0,1);o=funcToWorld(markerPosition.x,i);mgraphics.move_to(o.x*funcViewScale.x+e,o.y*funcViewScale.y),mgraphics.line_to(o.x*funcViewScale.x-e,o.y*funcViewScale.y),mgraphics.stroke(),mgraphics.move_to(o.x*funcViewScale.x,o.y*funcViewScale.y-e),mgraphics.line_to(o.x*funcViewScale.x,o.y*funcViewScale.y+e),mgraphics.stroke(),mgraphics.set_source_rgba(1,1,1,.15*markercolor[3]),o=funcToWorld(markerPosition.x,0),mgraphics.move_to(o.x*funcViewScale.x,o.y*funcViewScale.y),o=funcToWorld(markerPosition.x,markerInputFloat),mgraphics.line_to(o.x*funcViewScale.x,o.y*funcViewScale.y),mgraphics.stroke(),1==showLabel&&(mgraphics.set_source_rgba(1,1,1,.5*markercolor[3]),o=funcToWorld(markerPosition.x,0),mgraphics.move_to(o.x*funcViewScale.x,o.y*funcViewScale.y-1.1*pointSize),mgraphics.show_text(markerPosition.x.toFixed(2)))}}function paint_label_func(){}function paint_box_func(){if(1==showBox){mgraphics.set_source_rgba(boundingboxcolor);var e=funcToWorld(0,1),o=funcToWorld(1,0);mgraphics.rectangle(e.x*funcViewScale.x,e.y*funcViewScale.y,(o.x-e.x)*funcViewScale.x,(o.y-e.y)*-funcViewScale.y),mgraphics.stroke()}}function set_centroid(e,o){gCentroid.x=e,gCentroid.y=o,mgraphics.redraw()}function paint_centroid_func(){if(1==showCentroid){var e=funcToWorld(gCentroid.x,gCentroid.y);e.x=e.x*funcViewScale.x,e.y=e.y*funcViewScale.y,mgraphics.set_source_rgba(centroidcolor),mgraphics.rectangle(e.x-.35*pointSize,e.y+.35*pointSize,.7*pointSize,.7*pointSize),mgraphics.stroke(),mgraphics.move_to(e.x-pointSize,e.y),mgraphics.line_to(e.x-.35*pointSize,e.y),mgraphics.move_to(e.x+pointSize,e.y),mgraphics.line_to(e.x+.35*pointSize,e.y),mgraphics.move_to(e.x,e.y-pointSize),mgraphics.line_to(e.x,e.y-.35*pointSize),mgraphics.move_to(e.x,e.y+pointSize),mgraphics.line_to(e.x,e.y+.35*pointSize),mgraphics.stroke(),1==showLabel&&(mgraphics.select_font_face("Arial"),mgraphics.set_font_size(9),mgraphics.move_to(e.x+pointSize,e.y),mgraphics.show_text("C"))}}function onclick(e,o,i,t,n,l,r,a){var c=new Point,s=new Point,p=new Point;mouseOverOption=!1,mouseToWorld(e,o),0==t&&0==r&&0==a&&(viewMode<=2?(worldMouse.x/=viewScale,worldMouse.y/=viewScale):4==viewMode&&(worldMouse.x/=funcViewScale.x,worldMouse.y/=funcViewScale.y)),haveHit=0,hitPointID=-1e3;for(var g=0;g<polyCount;g++)if(0==viewMode?(c.x=polygon[g].x,c.y=polygon[g].y):1==viewMode?(c.x=polygon[g].x,c.y=polygon[g].z):2==viewMode?(c.x=polygon[g].y,c.y=polygon[g].z):4==viewMode&&(c=funcToWorld(polygon[g].x,polygon[g].y)),distance2d(worldMouse.x,worldMouse.y,c.x,c.y)<searchRadius){hitPointID=g,outlet(0,"move_point",hitPointID,polygon[hitPointID].x,polygon[hitPointID].y,polygon[hitPointID].z),haveHit=1;break}1==showHandles&&0==haveHit?(0==viewMode?(c.x=handle[0].x,c.y=handle[0].y,s.x=handle[1].x,s.y=handle[1].y):1==viewMode?(c.x=handle[0].x,c.y=handle[0].z,s.x=handle[1].x,s.y=handle[1].z):2==viewMode?(c.x=handle[0].y,c.y=handle[0].z,s.x=handle[1].y,s.y=handle[1].z):4==viewMode&&(c=funcToWorld(handle[0].x,handle[0].y),s=funcToWorld(handle[1].x,handle[1].y)),distance2d(worldMouse.x,worldMouse.y,c.x,c.y)<searchRadius?(hitPointID=-2,outlet(0,"endpoint",0,handle[0].x,handle[0].y,handle[0].z),haveHit=1):distance2d(worldMouse.x,worldMouse.y,s.x,s.y)<searchRadius&&(hitPointID=-1,outlet(0,"endpoint",1,handle[1].x,handle[1].y,handle[1].z),haveHit=1)):1==showCentroid&&0==haveHit&&(0==viewMode?(p.x=gCentroid.x,p.y=gCentroid.y):1==viewMode?(p.x=gCentroid.x,p.y=gCentroid.z):2==viewMode?(p.x=gCentroid.y,p.y=gCentroid.z):4==viewMode&&(p=funcToWorld(gCentroid.x,gCentroid.y),calcFuncConstraints()),distance2d(worldMouse.x,worldMouse.y,p.x,p.y)<searchRadius&&(hitPointID=-3,haveHit=1)),storedMouse.x=worldMouse.x,storedMouse.y=worldMouse.y}function ondrag(e,o,i,t,n,l,r,a){var c=new Point,s=new Point;if(1==i)if(0==t&&0==r&&0==a){if(3!=viewMode){if(mouseToWorld(e,o),viewMode<=2?(worldMouse.x/=viewScale,worldMouse.y/=viewScale):4==viewMode&&(worldMouse.x/=funcViewScale.x,worldMouse.y/=funcViewScale.y),hitPointID>=0)0==viewMode?0==snapToGrid?(polygon[hitPointID].x=worldMouse.x,polygon[hitPointID].y=worldMouse.y):(c=grid_snap(worldMouse.x,worldMouse.y),polygon[hitPointID].x=c.x,polygon[hitPointID].y=c.y):1==viewMode?0==snapToGrid?(polygon[hitPointID].x=worldMouse.x,polygon[hitPointID].z=worldMouse.y):(c=grid_snap(worldMouse.x,worldMouse.y),polygon[hitPointID].x=c.x,polygon[hitPointID].z=c.y):2==viewMode?0==snapToGrid?(polygon[hitPointID].y=worldMouse.x,polygon[hitPointID].z=worldMouse.y):(c=grid_snap(worldMouse.x,worldMouse.y),polygon[hitPointID].y=c.x,polygon[hitPointID].z=c.y):4==viewMode&&(0==snapToGrid?(c=worldToFunc(worldMouse.x,worldMouse.y),polygon[hitPointID].x=c.x,polygon[hitPointID].y=c.y):(c=grid_snap((c=worldToFunc(worldMouse.x,worldMouse.y)).x,c.y),polygon[hitPointID].x=c.x,polygon[hitPointID].y=c.y),calcFuncConstraints()),1==autoHandles&&make_handles(),calcPolyCentroid(),mgraphics.redraw(),outlet(0,"move_point",hitPointID,polygon[hitPointID].x,polygon[hitPointID].y,polygon[hitPointID].z),resetMarker();else if(hitPointID>-4)if(-2!=hitPointID&&-1!=hitPointID||0!=autoHandles){if(-3==hitPointID){var p=worldMouse.x-storedMouse.x,g=worldMouse.y-storedMouse.y;0==viewMode?calcPolyTranslate(polyTranslate.x+p,polyTranslate.y+g,0):1==viewMode?calcPolyTranslate(polyTranslate.x+p,0,polyTranslate.z+g):2==viewMode&&calcPolyTranslate(0,polyTranslate.y+p,polyTranslate.z+g),mgraphics.redraw(),outlet(1,"translate_polygon",polyTranslate.x,polyTranslate.y,polyTranslate.z),storedMouse.x=worldMouse.x,storedMouse.y=worldMouse.y}}else{var d=0;if(-2==hitPointID?d=0:-1==hitPointID&&(d=1),0==viewMode)0==snapToGrid?(handle[d].x=worldMouse.x,handle[d].y=worldMouse.y):(c=grid_snap(worldMouse.x,worldMouse.y),handle[d].x=c.x,handle[d].y=c.y);else if(1==viewMode)0==snapToGrid?(handle[d].x=worldMouse.x,handle[d].z=worldMouse.y):(c=grid_snap(worldMouse.x,worldMouse.y),handle[d].x=c.x,handle[d].z=c.y);else if(2==viewMode)0==snapToGrid?(handle[d].y=worldMouse.x,handle[d].z=worldMouse.y):(c=grid_snap(worldMouse.x,worldMouse.y),handle[d].y=c.x,handle[d].z=c.y);else if(4==viewMode)if(0==snapToGrid){s=worldToFunc(worldMouse.x,worldMouse.y);handle[d].x=s.x,handle[d].y=s.y}else{c=grid_snap((s=worldToFunc(worldMouse.x,worldMouse.y)).x,s.y),handle[d].x=c.x,handle[d].y=c.y}mgraphics.redraw(),outlet(0,"endpoint",d,handle[d].x,handle[d].y,handle[d].z),resetMarker()}}else if(3==viewMode){mouseToWorld(e,o),worldMouse.x/=viewScale,worldMouse.y/=viewScale;p=worldMouse.x-storedMouse.x,g=worldMouse.y-storedMouse.y;gOrbit.x+=25*p,gOrbit.y-=20*g,orbit3D(gOrbit.x,gOrbit.y,gOrbit.z),update(),outlet(1,"orbit3D",gOrbit.x,gOrbit.y,gOrbit.z),mgraphics.redraw(),storedMouse.x=worldMouse.x,storedMouse.y=worldMouse.y}}else if(1==t){mouseToWorld(e,o);p=worldMouse.x-storedMouse.x,g=worldMouse.y-storedMouse.y;viewMode<=2?(viewTranslate.x+=.5*p,viewTranslate.y-=.5*g):3==viewMode?(viewTranslate.x-=.4*p,viewTranslate.y+=.4*g):4==viewMode&&(viewTranslate.x+=.8*p,viewTranslate.y-=.8*g),originToPixel(),calcViewRect(),storedMouse.x=worldMouse.x,storedMouse.y=worldMouse.y,outlet(1,"translateview",viewTranslate.x,viewTranslate.y),mgraphics.redraw()}else if(1==r){mouseToWorld(e,o);p=worldMouse.x-storedMouse.x,g=worldMouse.y-storedMouse.y;if(p=clip(p,-10,10),g=clip(g,-10,10),viewMode<=2)viewScale=clip(viewScale+=g*(y=.1*viewScale),.01,100),originToPixel(),calcViewRect();else if(3==viewMode)gOrbit.z+=g,orbit3D(gOrbit.x,gOrbit.y,gOrbit.z),update(),outlet(1,"orbit3D",gOrbit.x,gOrbit.y,gOrbit.z);else if(4==viewMode){var y=.16*funcViewScale.y;funcViewScale.y+=g*y,funcViewScale.y=clip(funcViewScale.y,.01,100),y=.16*funcViewScale.x,funcViewScale.x+=p*y,funcViewScale.x=clip(funcViewScale.x,.01,100),originToPixel(),calcViewRect(),outlet(1,"scaleviewf",funcViewScale.x,funcViewScale.y)}storedMouse.x=worldMouse.x,storedMouse.y=worldMouse.y,outlet(1,"scaleview",viewScale),mgraphics.redraw()}}function ondblclick(e,o,i,t,n,l,r,a){var c=new Point;if(mouseToWorld(e,o),1==t||1==r)viewMode<=3?(viewTranslate.x=initialViewOffset.x,viewTranslate.y=initialViewOffset.y,oneOverViewScale=1/(viewScale=initialViewScale),3==viewMode&&orbit3D(-30,30,4),outlet(1,"translateview",viewTranslate.x,viewTranslate.y),outlet(1,"scaleview",viewScale),originToPixel(),calcViewRect(),mgraphics.redraw()):4==viewMode&&(viewTranslate.x=0,viewTranslate.y=0,funcViewScale.x=.95,funcViewScale.y=.95,outlet(1,"translateview",viewTranslate.x,viewTranslate.y),outlet(1,"scaleviewf",funcViewScale.x,funcViewScale.y),mgraphics.redraw());else if(1==n){if(hitPointID=-3,viewMode<=2){worldMouse.x/=viewScale,worldMouse.y/=viewScale;for(var s=0;s<polyCount;s++)if(distance2d(worldMouse.x,worldMouse.y,polygon[s].x,polygon[s].y)<searchRadius){polygon_remove(s),polyCount--,mgraphics.redraw(),dumpPolygon();break}}else if(4==viewMode){worldMouse.x/=funcViewScale.x,worldMouse.y/=funcViewScale.y;for(s=0;s<polyCount;s++)if(c=funcToWorld(polygon[s].x,polygon[s].y),distance2d(worldMouse.x,worldMouse.y,c.x,c.y)<searchRadius){polygon_remove(s),polyCount--,mgraphics.redraw(),dumpPolygon();break}calcFuncConstraints()}}else viewMode<=2?(worldMouse.x/=viewScale,worldMouse.y/=viewScale,insertPoint(worldMouse.x,worldMouse.y)):4==viewMode&&(worldMouse.x/=funcViewScale.x,worldMouse.y/=funcViewScale.y,insertPoint((c=worldToFunc(worldMouse.x,worldMouse.y)).x,c.y),calcFuncConstraints()),mgraphics.redraw()}function onresize(e,o){return e=this.box.rect[2]-this.box.rect[0],o=this.box.rect[3]-this.box.rect[1],pointSize=pointSizePX/(.5*o),searchRadius=searchRadiusPX/(.5*o),gAspect=e/o,originToPixel(),calcViewRect(),viewport_size(e,o),gAspect}function calcAspect(){gWidth=this.box.rect[2]-this.box.rect[0],gHeight=this.box.rect[3]-this.box.rect[1],gAspect=gWidth/gHeight,gOneOverHalfHeight=1/(.5*gHeight),originToPixel(),viewport_size(gWidth,gHeight)}function calcViewRect(){if(viewMode<3)viewRect.x1=-1*gAspect-viewTranslate.x,viewRect.y1=1+viewTranslate.y,viewRect.x2=gAspect+-1*viewTranslate.x,viewRect.y2=-1+viewTranslate.y,gridSpacing=1,unitLineStart_x=Math.ceil(viewRect.x1/(gridSpacing*viewScale))*(gridSpacing*viewScale),numUnitLines_x=Math.floor((viewRect.x2-viewRect.x1)/(gridSpacing*viewScale))+viewScale,unitLineStart_y=Math.ceil(viewRect.y2/(gridSpacing*viewScale))*(gridSpacing*viewScale),numUnitLines_y=Math.floor((viewRect.y1-viewRect.y2)/(gridSpacing*viewScale))+viewScale,gridSpacing=1/gridStep,fineLineStart_x=Math.ceil(viewRect.x1/(gridSpacing*viewScale))*(gridSpacing*viewScale),numFineLines_x=Math.floor((viewRect.x2-viewRect.x1)/(gridSpacing*viewScale))+viewScale,fineLineStart_y=Math.ceil(viewRect.y2/(gridSpacing*viewScale))*(gridSpacing*viewScale),numFineLines_y=Math.floor((viewRect.y1-viewRect.y2)/(gridSpacing*viewScale))+viewScale,labelPosition=pixelToWorld(5,10);else if(4==viewMode){var e=funcToWorld(0,1);viewRect.x1=e.x,viewRect.y1=e.y;var o=funcToWorld(1,0);viewRect.x2=o.x,viewRect.y2=o.y,gridSpacing=1,unitLineStart_x=Math.ceil(viewRect.x1/(gridSpacing*funcViewScale.x))*(gridSpacing*funcViewScale.x),numUnitLines_x=Math.floor((viewRect.x2-viewRect.x1)/(gridSpacing*funcViewScale.x))+funcViewScale.x,unitLineStart_y=Math.ceil(viewRect.y2/(gridSpacing*funcViewScale.y))*(gridSpacing*funcViewScale.y),numUnitLines_y=Math.floor((viewRect.y1-viewRect.y2)/(gridSpacing*funcViewScale.y))+funcViewScale.y,gridSpacing=1/gridStep,fineLineStart_x=Math.ceil(viewRect.x1/(gridSpacing*funcViewScale.x))*(gridSpacing*funcViewScale.x),numFineLines_x=gridStep,fineLineStart_y=Math.ceil(viewRect.y2/(gridSpacing*funcViewScale.y))*(gridSpacing*funcViewScale.y),numFineLines_y=gridStep}}function calcPointSize(){gWidth=this.box.rect[2]-this.box.rect[0],gHeight=this.box.rect[3]-this.box.rect[1],pointSize=pointSizePX/(.5*gHeight),searchRadius=searchRadiusPX/(.5*gHeight)}function calcBoundingBox(e,o,i){e<gBoxMin.x&&(gBoxMin.x=e),e>gBoxMax.x&&(gBoxMax.x=e),o<gBoxMin.y&&(gBoxMin.y=o),o>gBoxMax.y&&(gBoxMax.y=o),i<gBoxMin.z&&(gBoxMin.z=i),i>gBoxMax.z&&(gBoxMax.z=i),gBoxCenter.x=.5*(gBoxMax.x-gBoxMin.x)+gBoxMin.x,gBoxCenter.y=.5*(gBoxMax.y-gBoxMin.y)+gBoxMin.y,gBoxCenter.z=.5*(gBoxMax.z-gBoxMin.z)+gBoxMin.z}function resetBoundingBox(){gBoxMin.x=gBoxMin.y=gBoxMin.z=Number.MAX_VALUE,gBoxMax.x=gBoxMax.y=gBoxMax.z=-Number.MAX_VALUE}function calcPolyCentroid(){var e=new Point;e.x=e.y=e.z=0;for(var o=0;o<polyCount;o++)e.x+=polygon[o].x,e.y+=polygon[o].y,e.z+=polygon[o].z;gCentroid.x=e.x/polyCount,gCentroid.y=e.y/polyCount,gCentroid.z=e.z/polyCount}function calcPolyScale(e,o,i){var t=new Point;if(t.x=e/polyScale.x,t.y=o/polyScale.y,t.z=i/polyScale.z,polyCount>0)for(var n=0;n<polyCount;n++)polygon[n].x=(polygon[n].x-gBoxCenter.x)*t.x+gBoxCenter.x,polygon[n].y=(polygon[n].y-gBoxCenter.y)*t.y+gBoxCenter.y,polygon[n].z=(polygon[n].z-gBoxCenter.z)*t.z+gBoxCenter.z;polyScale.x=e,polyScale.y=o,polyScale.z=i,calcPolyCentroid(),dumpPolygon(),mgraphics.redraw()}function calcPolyTranslate(e,o,i){var t=new Point;if(t.x=e-polyTranslate.x,t.y=o-polyTranslate.y,t.z=i-polyTranslate.z,polyCount>0)for(var n=0;n<polyCount;n++)polygon[n].x+=t.x,polygon[n].y+=t.y,polygon[n].z+=t.z;handle[0].x+=t.x,handle[0].y+=t.y,handle[0].z+=t.z,handle[1].x+=t.x,handle[1].y+=t.y,handle[1].z+=t.z,polyTranslate.x=e,polyTranslate.y=o,polyTranslate.z=i,dumpPolygon(),mgraphics.redraw(),calcPolyCentroid()}function calcPolyRotate(e,o,i){var t=new Point,n=new Array(3),l=new Array;if(t.x=e-polyRotate.x,t.y=o-polyRotate.y,t.z=i-polyRotate.z,scene_rotation(t.x,t.y,t.z),polyCount>0)for(var r=0;r<polyCount;r++)n[0]=polygon[r].x-gCentroid.x,n[1]=polygon[r].y-gCentroid.y,n[2]=polygon[r].z-gCentroid.z,l=point_rotation_by_quaternion(n,rotationQuat),polygon[r].x=l[1]+gCentroid.x,polygon[r].y=l[2]+gCentroid.y,polygon[r].z=l[3]+gCentroid.z;polyRotate.x=e,polyRotate.y=o,polyRotate.z=i;for(var a=0;a<2;a++)n[0]=handle[a].x-gCentroid.x,n[1]=handle[a].y-gCentroid.y,n[2]=handle[a].z-gCentroid.z,l=point_rotation_by_quaternion(n,rotationQuat),handle[a].x=l[1]+gCentroid.x,handle[a].y=l[2]+gCentroid.y,handle[a].z=l[3]+gCentroid.z;calcPolyCentroid(),dumpPolygon(),mgraphics.redraw()}function calcFuncConstraints(){polyCount>0&&move_point(0,polygon[0].x,polygon[0].y,polygon[0].z),polyCount>1&&move_point(polyCount-1,polygon[polyCount-1].x,polygon[polyCount-1].y,polygon[polyCount-1].z)}function mouseToWorld(e,o){return calcAspect(),viewMode<=3?(worldMouse.x=(e-.5*gWidth)/(.5*gHeight),worldMouse.y=(.5*gHeight-o)/(.5*gHeight),worldMouse.x-=viewTranslate.x,worldMouse.y+=viewTranslate.y):4==viewMode&&(worldMouse.x=(e-.5*gWidth)/(.5*gHeight),worldMouse.y=(.5*gHeight-o)/(.5*gHeight),worldMouse.x-=viewTranslate.x,worldMouse.y+=viewTranslate.y),worldMouse}function pixelToWorld(e,o){var i=new Point;return calcAspect(),i.x=(e-.5*gWidth)/(.5*gHeight),i.y=(.5*gHeight-o)/(.5*gHeight),viewMode<3&&(i.x-=viewTranslate.x,i.y+=viewTranslate.y),i}function worldToPixel(e,o){gWidth=this.box.rect[2]-this.box.rect[0],gHeight=this.box.rect[3]-this.box.rect[1],worldPX.x=e*gHeight*.5+.5*gWidth,worldPX.y=o*gHeight*.5*-1+.5*gHeight,worldPX.x+=viewTranslate.x*(.5*gHeight),worldPX.y+=viewTranslate.y*(.5*gHeight)}function funcToWorld(e,o){var i=new Point;return i.x=2*e*gAspect-gAspect,i.y=2*o-1,i}function worldToFunc(e,o){var i=new Point;return i.x=.5*e/gAspect+.5,i.y=.5*o+.5,i}function originToPixel(){viewMode<=3?(originPX.x=.5*gWidth,originPX.y=.5*gHeight,originPX.x+=viewTranslate.x*(.5*gHeight),originPX.y+=viewTranslate.y*(.5*gHeight)):4==viewMode&&(originPX.x=.5*gWidth*funcViewScale.x,originPX.y=.5*gHeight*funcViewScale.y,originPX.x+=viewTranslate.x*(.5*gHeight)*funcViewScale.x,originPX.y+=viewTranslate.y*(.5*gHeight)*funcViewScale.y)}function dumpPolygon(){for(var e=new Array,o=0;o<polyCount;o++)e.push(polygon[o].x),e.push(polygon[o].y),e.push(polygon[o].z);outlet(0,e),outlet(0,"endpoint",0,handle[0].x,handle[0].y,handle[0].z),outlet(0,"endpoint",1,handle[1].x,handle[1].y,handle[1].z),outlet(0,"bang"),resetMarker()}function resetMarker(){polyCount>0&&(markerPosition.x=polygon[0].x,markerPosition.y=polygon[0].y,markerPosition.z=polygon[0].z),markerInputFloat=0}function polygon_insert(e,o,i,t){var n=new Point;n.x=o,n.y=i,n.z=t,polygon.splice(e,0,n),polyCount++}function polygon_prepend(e,o,i){var t=new Point;t.x=e,t.y=o,t.z=i,polygon.unshift(t),polyCount++}function polygon_append(e,o,i){var t=new Point;t.x=e,t.y=o,t.z=i,polygon.push(t),polyCount++}function polygon_remove(e){polygon.splice(e,1),mgraphics.redraw()}function clear(){polyCount=0,splineCount=0,outlet(0,"clear"),mgraphics.redraw()}function dump(){dumpPolygon()}function move_point(e,o,i,t){e>=0&&e<polyCount&&(viewMode<=3?0==splineClosed&&e<polyCount?(polygon[e].x=o,polygon[e].y=i,polygon[e].z=t):1==splineClosed&&e<polyCount-1&&(polygon[e].x=o,polygon[e].y=i,polygon[e].z=t):4==viewMode&&(0==e?(polygon[e].x=0,polygon[e].y=clip(i,0,1),polygon[e].z=0):e==polyCount-1?(polygon[e].x=1,polygon[e].y=clip(i,0,1),polygon[e].z=0):(polygon[e].x=o,polygon[e].y=i,polygon[e].z=t)),outlet(0,"move_point",e,polygon[e].x,polygon[e].y,polygon[e].z),resetMarker(),mgraphics.redraw())}function endpoint(e,o,i,t){handle[e].x=o,handle[e].y=i,handle[e].z=t,mgraphics.redraw(),outlet(0,"endpoint",e,handle[e].x,handle[e].y,handle[e].z)}function set_endpoint(e,o,i,t){handle[e].x=o,handle[e].y=i,handle[e].z=t}function insertPoint(e,o){var i=new Point;if(i.x=e,i.y=o,i.z=0,0==polyCount)hitPointID=0,polygon_insert(1,i.x,i.y,i.z);else if(1==polyCount)hitPointID=1,polygon_insert(2,i.x,i.y,i.z);else if(2==polyCount){var t=angleTo(polygon[0].x,polygon[0].y,polygon[1].x,polygon[1].y),n=t-angleTo(polygon[0].x,polygon[0].y,i.x,i.y);if(n>.5*Math.PI||n<.5*-Math.PI){polygon_insert(0,i.x,i.y,i.z);var l=t-angleTo(polygon[1].x,polygon[1].y,i.x,i.y)}else l>.5*-Math.PI?polygon_insert(1,i.x,i.y,i.z):l<.5*Math.PI?polygon_insert(2,i.x,i.y,i.z):polygon_insert(1,i.x,i.y,i.z)}else{var r=new Point,a=1e6,c=0;r.x=i.x,r.y=i.y;var s=-3;if(0==splineClosed){a=1e6,(c=linesegmentDistance(handle[0].x,handle[0].y,polygon[0].x,polygon[0].y,r.x,r.y))<a&&(s=-2,a=c),(c=linesegmentDistance(handle[1].x,handle[1].y,polygon[polyCount-1].x,polygon[polyCount-1].y,r.x,r.y))<a&&(s=-1,a=c);for(var p=0;p<polyCount-1;p++)(c=linesegmentDistance(polygon[p].x,polygon[p].y,polygon[p+1].x,polygon[p+1].y,r.x,r.y))<a&&(s=p,a=c)}else if(1==splineClosed){a=1e6,(c=linesegmentDistance(polygon[polyCount-1].x,polygon[polyCount-1].y,polygon[0].x,polygon[0].y,r.x,r.y))<a&&(s=-2,a=c),(c=linesegmentDistance(polygon[0].x,polygon[0].y,polygon[polyCount-1].x,polygon[polyCount-1].y,r.x,r.y))<a&&(s=-1,a=c);for(p=0;p<polyCount-1;p++)(c=linesegmentDistance(polygon[p].x,polygon[p].y,polygon[p+1].x,polygon[p+1].y,r.x,r.y))<a&&(s=p,a=c)}-2==s?polygon_prepend(r.x,r.y,r.z):-1==s?polygon_append(r.x,r.y,r.z):polygon_insert(s+1,r.x,r.y,r.z)}1==autoHandles&&make_handles(),dumpPolygon(),mgraphics.redraw()}function linesegmentDistance(e,o,i,t,n,l){var r,a,c;if(0==(a=distanceSquared2d(e,o,i,t)))return distance2d(n,l,e,o);var s=i-e,p=t-o;return r=dot(n-e,l-o,s,p)/a,distance2d(n,l,e+(c=Math.max(0,Math.min(1,r)))*s,o+c*p)}function distance2d(e,o,i,t){var n=i-e,l=t-o;return Math.sqrt(n*n+l*l)}function distanceSquared2d(e,o,i,t){var n=i-e,l=t-o;return n*n+l*l}function dot(e,o,i,t){return e*i+o*t}function make_handles(){polyCount>=2&&1==autoHandles&&(0==splineClosed?polyCount>1&&(handle[0].x=polygon[0].x-.5*(polygon[1].x-polygon[0].x),handle[0].y=polygon[0].y-.5*(polygon[1].y-polygon[0].y),handle[0].z=polygon[0].z-.5*(polygon[1].z-polygon[0].z),handle[1].x=polygon[polyCount-1].x+.5*(polygon[polyCount-1].x-polygon[polyCount-2].x),handle[1].y=polygon[polyCount-1].y+.5*(polygon[polyCount-1].y-polygon[polyCount-2].y),handle[1].z=polygon[polyCount-1].z+.5*(polygon[polyCount-1].z-polygon[polyCount-2].z)):1==splineClosed&&(handle[0].x=polygon[polyCount-1].x,handle[0].y=polygon[polyCount-1].y,handle[0].z=polygon[polyCount-1].z,handle[1].x=polygon[1].x,handle[1].y=polygon[1].y,handle[1].z=polygon[1].z),outlet(0,"endpoint",0,handle[0].x,handle[0].y,handle[0].z))}function angleBetween(e,o,i,t){var n=(e*i+o*t)/(Math.sqrt(e*e+o*o)*Math.sqrt(i*i+t*t));return n>=1?0:n<=-1?Math.PI:Math.acos(n)}function angleTo(e,o,i,t){var n=i-e,l=t-o;return Math.atan2(n,l)}function to_degrees(e){return 57.29577951308232*e}function to_radians(e){return.0174532925199432*e}function clip(e,o,i){return Math.max(Math.min(e,Math.max(o,i)),Math.min(o,i))}function grid_snap(e,o){var i=new Point;return i.x=Math.round(e*gridStep)/gridStep,i.y=Math.round(o*gridStep)/gridStep,i}function grid_snap3D(e,o,i){var t=new Point;return t.x=Math.round(e*gridStep)/gridStep,t.y=Math.round(o*gridStep)/gridStep,t.z=Math.round(i*gridStep)/gridStep,t}function save(){viewMode<=3&&set_initial_view(),embedmessage("auto_handles",autoHandles),embedmessage("show_handles",showHandles),embedmessage("show_marker",showMarker),embedmessage("show_points",showPoints),embedmessage("show_poly",showPoly),embedmessage("show_grid",showGrid),embedmessage("show_spline",showSpline),embedmessage("show_axes",showAxes),embedmessage("show_label",showLabel),embedmessage("show_box",showBox),embedmessage("snap_to_grid",snapToGrid),embedmessage("pointsize",pointSizePX),embedmessage("gridstep",gridStep),embedmessage("bg_color",bgcolor[0],bgcolor[1],bgcolor[2],bgcolor[3]),embedmessage("spline_color",splinecolor[0],splinecolor[1],splinecolor[2],splinecolor[3]),embedmessage("polygon_color",polygoncolor[0],polygoncolor[1],polygoncolor[2],polygoncolor[3]),embedmessage("handle0_color",handlecolor0[0],handlecolor0[1],handlecolor0[2],handlecolor0[3]),embedmessage("handle1_color",handlecolor1[0],handlecolor1[1],handlecolor1[2],handlecolor1[3]),embedmessage("point_color",pointcolor[0],pointcolor[1],pointcolor[2],pointcolor[3]),embedmessage("text_color",textcolor[0],textcolor[1],textcolor[2],textcolor[3]),embedmessage("marker_color",markercolor[0],markercolor[1],markercolor[2],markercolor[3]),embedmessage("grid_color",gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]),embedmessage("label_color",labelcolor[0],labelcolor[1],labelcolor[2],labelcolor[3]),embedmessage("boundingbox_color",boundingboxcolor[0],boundingboxcolor[1],boundingboxcolor[2],boundingboxcolor[3]),embedmessage("initial_view_offset",initialViewOffset.x,initialViewOffset.y),embedmessage("initial_view_scale",initialViewScale),embedmessage("scale_viewf",funcViewScale.x,funcViewScale.y),embedmessage("read_mode",readMode),embedmessage("loadsaved");for(var e=0;e<polyCount;e++)embedmessage("polygon_append",polygon[e].x,polygon[e].y,polygon[e].z);embedmessage("set_endpoint",0,handle[0].x,handle[0].y,handle[0].z),embedmessage("set_endpoint",1,handle[1].x,handle[1].y,handle[1].z),embedmessage("set_closed",splineClosed),embedmessage("set_viewMode",viewMode)}function loadsaved(){viewTranslate.x=initialViewOffset.x,viewTranslate.y=initialViewOffset.y,outlet(1,"translateview",viewTranslate.x,viewTranslate.y),outlet(1,"scaleview",viewScale),outlet(1,"scaleviewf",funcViewScale.x,funcViewScale.y),outlet(1,"view_mode",viewMode),outlet(1,"readmode",readMode),calcViewRect()}function load_sync_external(){task.schedule(100)}function load_sync_external_task(){dumpPolygon(),closed(splineClosed),view_mode(viewMode)}function loadbang(){outlet(1,"closed","set",splineClosed),outlet(1,"autohandles","set",autoHandles),outlet(1,"showhandles","set",showHandles),outlet(1,"showmarker","set",showMarker),outlet(1,"showpoints","set",showPoints),outlet(1,"showpoly","set",showPoly),outlet(1,"showgrid","set",showGrid),outlet(1,"showspline","set",showSpline),outlet(1,"showaxes","set",showAxes),outlet(1,"showlabel","set",showLabel),outlet(1,"showbox","set",showBox),outlet(1,"snaptogrid","set",snapToGrid),outlet(1,"pointsize","set",pointSizePX),outlet(1,"gridstep","set",gridStep),outlet(1,"bg_color",bgcolor[0],bgcolor[1],bgcolor[2],bgcolor[3]),outlet(1,"spline_color",splinecolor[0],splinecolor[1],splinecolor[2],splinecolor[3]),outlet(1,"polygon_color",polygoncolor[0],polygoncolor[1],polygoncolor[2],polygoncolor[3]),outlet(1,"handle0_color",handlecolor0[0],handlecolor0[1],handlecolor0[2],handlecolor0[3]),outlet(1,"handle1_color",handlecolor1[0],handlecolor1[1],handlecolor1[2],handlecolor1[3]),outlet(1,"point_color",pointcolor[0],pointcolor[1],pointcolor[2],pointcolor[3]),outlet(1,"text_color",textcolor[0],textcolor[1],textcolor[2],textcolor[3]),outlet(1,"marker_color",markercolor[0],markercolor[1],markercolor[2],markercolor[3]),outlet(1,"grid_color",gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]),outlet(1,"label_color",labelcolor[0],labelcolor[1],labelcolor[2],labelcolor[3]),viewTranslate.x=initialViewOffset.x,viewTranslate.y=initialViewOffset.y,oneOverViewScale=1/(viewScale=initialViewScale),outlet(1,"translateview",viewTranslate.x,viewTranslate.y),outlet(1,"scaleview",viewScale),outlet(1,"scaleviewf",funcViewScale.x,funcViewScale.y),outlet(1,"viewmode",viewMode),outlet(1,"readmode",readMode),gridstep(gridStep),calcPointSize(),calcViewRect(),gWidth=this.box.rect[2]-this.box.rect[0],gHeight=this.box.rect[3]-this.box.rect[1],originToPixel(),load_sync_external()}function save_settings(e){arrayfromargs(messagename,arguments);var o=new Dict,i=new Dict;i.append("display_flags",showHandles,showMarker,showPoints,showPoly,showSpline,showGrid,showAxes,showLabel,showBox,showCentroid),i.append("view_setting_0",translateScaleView[0].x,translateScaleView[0].y,translateScaleView[0].z),i.append("view_setting_1",translateScaleView[1].x,translateScaleView[1].y,translateScaleView[1].z),i.append("view_setting_2",translateScaleView[2].x,translateScaleView[2].y,translateScaleView[2].z),i.append("view_setting_3",translateScaleView[3].x,translateScaleView[3].y,translateScaleView[3].z),i.append("view_setting_4",translateScaleView[4].x,translateScaleView[4].y,funcViewScale.x,funcViewScale.y),i.append("view_orbit3d",gOrbit.x,gOrbit.y,gOrbit.z),i.append("view_range",gRange.x,gRange.y),i.append("view_fov",gFov),i.append("view_mode",viewMode),i.append("read_mode",readMode),i.append("pointSizePX",pointSizePX),i.append("gridStep",gridStep),i.append("bgcolor",bgcolor[0],bgcolor[1],bgcolor[2],bgcolor[3]),i.append("splinecolor",splinecolor[0],splinecolor[1],splinecolor[2],splinecolor[3]),i.append("polygoncolor",polygoncolor[0],polygoncolor[1],polygoncolor[2],polygoncolor[3]),i.append("handlecolor0",handlecolor0[0],handlecolor0[1],handlecolor0[2],handlecolor0[3]),i.append("handlecolor1",handlecolor1[0],handlecolor1[1],handlecolor1[2],handlecolor1[3]),i.append("pointcolor",pointcolor[0],pointcolor[1],pointcolor[2],pointcolor[3]),i.append("textcolor",textcolor[0],textcolor[1],textcolor[2],textcolor[3]),i.append("markercolor",markercolor[0],markercolor[1],markercolor[2],markercolor[3]),i.append("gridcolor",gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]),i.append("labelcolor",labelcolor[0],labelcolor[1],labelcolor[2],labelcolor[3]),i.append("boundingboxcolor",boundingboxcolor[0],boundingboxcolor[1],boundingboxcolor[2],boundingboxcolor[3]),i.append("centroidcolor",centroidcolor[0],centroidcolor[1],centroidcolor[2],centroidcolor[3]),o.append("setting_0",i),o.export_json(e)}function load_settings(e){var o=new Dict;o.readany(e);var i=o.get("setting_0");if(null!=i){var t=i.get("display_flags");show_handles(t[0]),show_marker(t[1]),show_points(t[2]),show_poly(t[3]),show_spline(t[4]),show_grid(t[5]),show_axes(t[6]),show_label(t[7]),show_box(t[8]),show_centroid(t[9]);var n=i.get("view_range");clipping_range(n[0],n[1]),fov(i.get("view_fov")),pointsize(i.get("pointSizePX")),gridstep(i.get("gridStep"));var l=i.get("view_setting_0");translateScaleView[0].x=l[0],translateScaleView[0].y=l[1],translateScaleView[0].z=l[2];var r=i.get("view_setting_1");translateScaleView[1].x=r[0],translateScaleView[1].y=r[1],translateScaleView[1].z=r[2];var a=i.get("view_setting_2");translateScaleView[2].x=a[0],translateScaleView[2].y=a[1],translateScaleView[2].z=a[2];var c=i.get("view_setting_3");translateScaleView[3].x=c[0],translateScaleView[3].y=c[1],translateScaleView[3].z=c[2];i.get("view_setting_3");translateScaleView[4].x=c[0],translateScaleView[4].y=c[1],funcViewScale.x=c[2],funcViewScale.x=c[3];var s=i.get("view_orbit3d");orbit3D(s[0],s[1],s[2]),view_mode(i.get("view_mode")),read_mode(i.get("read_mode"));var p=new Array(4);bg_color((p=i.get("bgcolor"))[0],p[1],p[2],p[3]),spline_color((p=i.get("splinecolor"))[0],p[1],p[2],p[3]),polygon_color((p=i.get("polygoncolor"))[0],p[1],p[2],p[3]),handle0_color((p=i.get("handlecolor0"))[0],p[1],p[2],p[3]),handle1_color((p=i.get("handlecolor1"))[0],p[1],p[2],p[3]),point_color((p=i.get("pointcolor"))[0],p[1],p[2],p[3]),text_color((p=i.get("textcolor"))[0],p[1],p[2],p[3]),marker_color((p=i.get("markercolor"))[0],p[1],p[2],p[3]),grid_color((p=i.get("gridcolor"))[0],p[1],p[2],p[3]),label_color((p=i.get("labelcolor"))[0],p[1],p[2],p[3]),boundingbox_color((p=i.get("boundingboxcolor"))[0],p[1],p[2],p[3]),centroid_color((p=i.get("centroidcolor"))[0],p[1],p[2],p[3]),calcPointSize(),calcViewRect(),gWidth=this.box.rect[2]-this.box.rect[0],gHeight=this.box.rect[3]-this.box.rect[1],originToPixel(),mgraphics.redraw()}else post('icst.spline_editor: no setting 0 in file "'+i+'"\n')}function store(e){if(post("presetID "+e+"\n"),polyCount>0){var o=new Dict;o.append("closed",splineClosed),o.append("auto_handles",autoHandles),translateScaleView[viewMode].x=viewTranslate.x,translateScaleView[viewMode].y=viewTranslate.y,translateScaleView[viewMode].z=viewScale,o.append("view_setting_0",translateScaleView[0].x,translateScaleView[0].y,translateScaleView[0].z),o.append("view_setting_1",translateScaleView[1].x,translateScaleView[1].y,translateScaleView[1].z),o.append("view_setting_2",translateScaleView[2].x,translateScaleView[2].y,translateScaleView[2].z),o.append("view_setting_3",translateScaleView[3].x,translateScaleView[3].y,translateScaleView[3].z),o.append("view_setting_4",translateScaleView[4].x,translateScaleView[4].y,funcViewScale.x,funcViewScale.y),o.append("view_orbit3d",gOrbit.x,gOrbit.y,gOrbit.z),o.append("view_fov",gFov),o.append("view_mode",viewMode),o.append("read_mode",readMode),o.append("point_count",polyCount);for(var i=0;i<polyCount;i++)o.append("point_"+i,polygon[i].x,polygon[i].y,polygon[i].z);o.append("handle_0",handle[0].x,handle[0].z,handle[0].z),o.append("handle_1",handle[1].x,handle[1].z,handle[1].z);var t="preset_"+e.toString();presetDict.contains(t)?presetDict.replace(t,o):(presetDict.append(t,o),outlet(1,"preset_menu","append",e))}}function recall(e){if(presetDict.contains("preset_"+e)){var o=presetDict.get("preset_"+e);polyCount=0,splineCount=0;var i=o.get("point_count");resetBoundingBox();for(var t=0;t<i;t++){if(null==polygon[t]){var n=new Point;polygon.push(n)}var l=o.get("point_"+t);polygon[t].x=l[0],polygon[t].y=l[1],polygon[t].z=l[2],polyCount++}var r=o.get("handle_0");endpoint(0,r[0],r[1],r[2]);var a=o.get("handle_1");endpoint(0,a[0],a[1],a[2]);for(t=0;t<5;t++){var c=o.get("view_setting_"+t);translateScaleView[t].x=c[0],translateScaleView[t].y=c[1],translateScaleView[t].z=c[2]}var s=o.get("view_setting_4");funcViewScale.x=s[2],funcViewScale.y=s[3],viewMode=o.get("view_mode"),readMode=o.get("read_mode"),translate_view(translateScaleView[viewMode].x,translateScaleView[viewMode].y),scale_view(translateScaleView[viewMode].z),scale_viewf(funcViewScale.x,funcViewScale.y),fov(o.get("view_fov"));var p=o.get("view_orbit3d");orbit3D(p[0],p[1],p[2]),closed(splineClosed=o.get("closed")),auto_handles(autoHandles=o.get("auto_handles")),originToPixel(),calcViewRect(),calcPolyCentroid(),dumpPolygon(),mgraphics.redraw(),outlet(1,"viewmode",viewMode),outlet(1,"readmode",readMode),outlet(1,"scaleview",viewScale),outlet(1,"scaleviewf",funcViewScale.x,funcViewScale.y),outlet(1,"translateview",viewTranslate.x,viewTranslate.y),outlet(1,"orbit3D",gOrbit.x,gOrbit.y,gOrbit.z)}}function remove(e){if(presetDict.contains("preset_"+e)){presetDict.remove("preset_"+e);var o=presetDict.getkeys();if(null==o)return void post('icst.spline_editor: no presets in file "'+filename+'"\n');if("string"==typeof o)outlet(1,"preset_menu","clear"),outlet(1,"preset_menu","append",o.slice(7));else if("object"==typeof o){var i=o.length;outlet(1,"preset_menu","clear");for(var t=0;t<i;t++)outlet(1,"preset_menu","append",o[t].slice(7))}}}function remove_all(){var e=presetDict.getkeys();if(null!=e){if("string"==typeof e)presetDict.remove(e);else if("object"==typeof e)for(var o=e.length,i=0;i<o;i++)presetDict.remove(e[i]);outlet(1,"preset_menu","clear"),clear()}else outlet(1,"preset_menu","clear")}function to_named_dict(e,o){if(null==e)var i=new Dict;else i=new Dict(e);var t=new Dict;t.append("closed",splineClosed),t.append("point_count",polyCount);for(var n=0;n<polyCount;n++){var l=polygon[n].x,r=polygon[n].x,a=polygon[n].x;t.append("point_"+n,l,r,a)}i.append("preset_"+o,t)}function read(e){presetDict.readany(e);var o=presetDict.getkeys();if(null!=o){if("string"==typeof o)outlet(1,"preset_menu","clear"),outlet(1,"preset_menu","append",o.slice(7));else if("object"==typeof o){var i=o.length;outlet(1,"preset_menu","clear");for(var t=0;t<i;t++)outlet(1,"preset_menu","append",o[t].slice(7))}}else post('icst.spline_editor: no presets in file "'+e+'"\n')}function write(e){presetDict.export_json(e)}function refer(e){presetDict.name=e}function closed(e){splineClosed=0==e?0:1,outlet(0,"closed",splineClosed),outlet(1,"closed","set",splineClosed),dumpPolygon()}function set_closed(e){splineClosed=0==e?0:1}function auto_handles(e){1==(autoHandles=0==e?0:1)&&make_handles(),outlet(1,"autohandles","set",autoHandles),mgraphics.redraw()}function show_handles(e){showHandles=0==e?0:1,outlet(1,"showhandles","set",showHandles),mgraphics.redraw()}function show_marker(e){showMarker=0==e?0:1,outlet(1,"showmarker","set",showMarker),mgraphics.redraw()}function show_points(e){showPoints=0==e?0:1,outlet(1,"showpoints","set",showPoints),mgraphics.redraw()}function show_poly(e){showPoly=0==e?0:1,outlet(1,"showpoly","set",showPoly),mgraphics.redraw()}function show_spline(e){showSpline=0==e?0:1,outlet(1,"showspline","set",showSpline),mgraphics.redraw()}function show_axes(e){showAxes=0==e?0:1,outlet(1,"showaxes","set",showAxes),mgraphics.redraw()}function show_grid(e){showGrid=0==e?0:1,outlet(1,"showgrid","set",showGrid),mgraphics.redraw()}function show_label(e){showLabel=0==e?0:1,outlet(1,"showlabel","set",showLabel),mgraphics.redraw()}function show_box(e){showBox=0==e?0:1,outlet(1,"showbox","set",showBox),mgraphics.redraw()}function show_centroid(e){showCentroid=0==e?0:1,outlet(1,"showcentroid","set",showCentroid),mgraphics.redraw()}function snap_to_grid(e){snapToGrid=0==e?0:1,outlet(1,"snaptogrid","set",snapToGrid),mgraphics.redraw()}function pointsize(e){pointSizePX=e,calcPointSize(),outlet(1,"pointsize","set",pointSizePX),mgraphics.redraw()}function gridstep(e){var o=Math.floor(e);gridStep=clip(o,1,50),gridSpacing=1/gridStep,calcViewRect(),outlet(1,"gridstep","set",gridStep),mgraphics.redraw()}function initial_view_offset(e,o){initialViewOffset.x=e,initialViewOffset.y=o,mgraphics.redraw()}function initial_view_scale(e){initialViewScale=e,mgraphics.redraw()}function set_initial_view(){initialViewOffset.x=viewTranslate.x,initialViewOffset.y=viewTranslate.y,initialViewScale=viewScale}function view_mode(e){translateScaleView[viewMode].x=viewTranslate.x,translateScaleView[viewMode].y=viewTranslate.y,translateScaleView[viewMode].z=viewScale,4==viewMode&&(translateScaleView[viewMode].z=funcViewScale),viewMode=clip(e,0,4),scale_view(translateScaleView[viewMode].z),translate_view(translateScaleView[viewMode].x,translateScaleView[viewMode].y),4==viewMode?(closed(0),auto_handles(1),readMode=1,outlet(0,"read_mode",readMode),outlet(1,"readmode","set",readMode)):(readMode=0,outlet(0,"read_mode",readMode),outlet(1,"readmode","set",readMode)),outlet(1,"viewmode","set",viewMode),mgraphics.redraw()}function set_viewMode(e){viewMode=clip(e,0,4)}function read_mode(e){readMode=clip(e,0,2),markerInputFloat=0,outlet(1,"readmode","set",readMode)}function translate_view(e,o){viewTranslate.x=e,viewTranslate.y=o,originToPixel(),calcViewRect(),outlet(1,"translateview",viewTranslate.x,viewTranslate.y),mgraphics.redraw()}function scale_view(e){viewScale=clip(e,.05,50),oneOverViewScale=1/viewScale,originToPixel(),calcViewRect(),outlet(1,"scaleview",viewScale),mgraphics.redraw()}function scale_viewf(e,o){funcViewScale.x=clip(e,.05,50),funcViewScale.y=clip(o,.05,50),originToPixel(),calcViewRect(),outlet(1,"scaleviewf",funcViewScale.x,funcViewScale.y),mgraphics.redraw()}function scale_polygon(e,o,i){calcPolyScale(Math.max(e,1e-4),Math.max(o,1e-4),Math.max(i,1e-4))}function translate_polygon(e,o,i){calcPolyTranslate(e,o,i)}function rotate_polygon(e,o,i){calcPolyRotate(e,o,i)}function bg_color(e,o,i,t){bgcolor[0]=clip(e,0,1),bgcolor[1]=clip(o,0,1),bgcolor[2]=clip(i,0,1),bgcolor[3]=clip(t,0,1),outlet(1,"bg_color",bgcolor[0],bgcolor[1],bgcolor[2],bgcolor[3]),mgraphics.redraw()}function spline_color(e,o,i,t){splinecolor[0]=clip(e,0,1),splinecolor[1]=clip(o,0,1),splinecolor[2]=clip(i,0,1),splinecolor[3]=clip(t,0,1),outlet(1,"spline_color",splinecolor[0],splinecolor[1],splinecolor[2],splinecolor[3]),mgraphics.redraw()}function polygon_color(e,o,i,t){polygoncolor[0]=clip(e,0,1),polygoncolor[1]=clip(o,0,1),polygoncolor[2]=clip(i,0,1),polygoncolor[3]=clip(t,0,1),outlet(1,"polygon_color",polygoncolor[0],polygoncolor[1],polygoncolor[2],polygoncolor[3]),mgraphics.redraw()}function handle0_color(e,o,i,t){handlecolor0[0]=clip(e,0,1),handlecolor0[1]=clip(o,0,1),handlecolor0[2]=clip(i,0,1),handlecolor0[3]=clip(t,0,1),outlet(1,"handle0_color",handlecolor0[0],handlecolor0[1],handlecolor0[2],handlecolor0[3]),mgraphics.redraw()}function handle1_color(e,o,i,t){handlecolor1[0]=clip(e,0,1),handlecolor1[1]=clip(o,0,1),handlecolor1[2]=clip(i,0,1),handlecolor1[3]=clip(t,0,1),outlet(1,"handle1_color",handlecolor1[0],handlecolor1[1],handlecolor1[2],handlecolor1[3]),mgraphics.redraw()}function point_color(e,o,i,t){pointcolor[0]=clip(e,0,1),pointcolor[1]=clip(o,0,1),pointcolor[2]=clip(i,0,1),pointcolor[3]=clip(t,0,1),outlet(1,"point_color",pointcolor[0],pointcolor[1],pointcolor[2],pointcolor[3]),mgraphics.redraw()}function text_color(e,o,i,t){textcolor[0]=clip(e,0,1),textcolor[1]=clip(o,0,1),textcolor[2]=clip(i,0,1),textcolor[3]=clip(t,0,1),outlet(1,"text_color",textcolor[0],textcolor[1],textcolor[2],textcolor[3]),mgraphics.redraw()}function marker_color(e,o,i,t){markercolor[0]=clip(e,0,1),markercolor[1]=clip(o,0,1),markercolor[2]=clip(i,0,1),markercolor[3]=clip(t,0,1),outlet(1,"marker_color",markercolor[0],markercolor[1],markercolor[2],markercolor[3]),mgraphics.redraw()}function grid_color(e,o,i,t){gridcolor[0]=clip(e,0,1),gridcolor[1]=clip(o,0,1),gridcolor[2]=clip(i,0,1),gridcolor[3]=clip(t,0,1),outlet(1,"grid_color",gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]),mgraphics.redraw()}function label_color(e,o,i,t){labelcolor[0]=clip(e,0,1),labelcolor[1]=clip(o,0,1),labelcolor[2]=clip(i,0,1),labelcolor[3]=clip(t,0,1),outlet(1,"label_color",labelcolor[0],labelcolor[1],labelcolor[2],labelcolor[3]),mgraphics.redraw()}function boundingbox_color(e,o,i,t){boundingboxcolor[0]=clip(e,0,1),boundingboxcolor[1]=clip(o,0,1),boundingboxcolor[2]=clip(i,0,1),boundingboxcolor[3]=clip(t,0,1),outlet(1,"boundingbox_color",boundingboxcolor[0],boundingboxcolor[1],boundingboxcolor[2],boundingboxcolor[3]),mgraphics.redraw()}function centroid_color(e,o,i,t){centroidcolor[0]=clip(e,0,1),centroidcolor[1]=clip(o,0,1),centroidcolor[2]=clip(i,0,1),centroidcolor[3]=clip(t,0,1),outlet(1,"centroid_color",centroidcolor[0],centroidcolor[1],centroidcolor[2],centroidcolor[3]),mgraphics.redraw()}function reset_colors(){bgcolor=[0,.125,.25,1],splinecolor=[.75,.9,1,.8],polygoncolor=[1,1,1,.3],handlecolor0=[.3,1,.9,.75],handlecolor1=[.3,.9,1,.75],pointcolor=[1,.5,0,1],textcolor=[1,1,1,.5],markercolor=[1,1,0,1],gridcolor=[1,1,1,.075],labelcolor=[1,1,1,.25],boundingboxcolor=[1,.75,.66,.35],centroidcolor=[.4,.8,1,.6666],mgraphics.redraw(),outlet(1,"bg_color",bgcolor[0],bgcolor[1],bgcolor[2],bgcolor[3]),outlet(1,"spline_color",splinecolor[0],splinecolor[1],splinecolor[2],splinecolor[3]),outlet(1,"polygon_color",polygoncolor[0],polygoncolor[1],polygoncolor[2],polygoncolor[3]),outlet(1,"handle0_color",handlecolor0[0],handlecolor0[1],handlecolor0[2],handlecolor0[3]),outlet(1,"handle1_color",handlecolor1[0],handlecolor1[1],handlecolor1[2],handlecolor1[3]),outlet(1,"point_color",pointcolor[0],pointcolor[1],pointcolor[2],pointcolor[3]),outlet(1,"text_color",textcolor[0],textcolor[1],textcolor[2],textcolor[3]),outlet(1,"marker_color",markercolor[0],markercolor[1],markercolor[2],markercolor[3]),outlet(1,"grid_color",gridcolor[0],gridcolor[1],gridcolor[2],gridcolor[3]),outlet(1,"label_color",labelcolor[0],labelcolor[1],labelcolor[2],labelcolor[3]),outlet(1,"boundingbox_color",boundingboxcolor[0],boundingboxcolor[1],boundingboxcolor[2],boundingboxcolor[3]),outlet(1,"centroid_color",centroidcolor[0],centroidcolor[1],centroidcolor[2],centroidcolor[3])}function project_3D(e,o,i){var t=new Point,n=new Point,l=new Point,r=new Point,a=new Point;return n.x=-e-gEye.x,n.y=i-gEye.y,n.z=-o-gEye.z,r.x=n.x*gCosYaw+n.z*gSinYaw,r.y=gSinPitch*(gSinYaw*n.x-gCosYaw*n.z)+gCosPitch*n.y,r.z=gCosPitch*(-gSinYaw*n.x+gCosYaw*n.z)+gSinPitch*n.y,1==range_check(r)&&(l.x=r.x*(gProjectionDistance/r.z),l.y=r.y*(gProjectionDistance/r.z),a.x=l.x*gCosRoll-l.y*gSinRoll,a.y=l.x*gSinRoll+l.y*gCosRoll,t.x=a.x+gSize.w,t.y=a.y-gSize.h,t.y*=-1,t.z=r.z),t=pixelToWorld(t.x,t.y)}function range_check(e){return gInRangeFlag=e.z>=gRange.x&&e.z<=gRange.y?1:0}function update(){var e=new Point;e.x=gPoi.x-gEye.x,e.y=gPoi.y-gEye.y,e.z=gPoi.z-gEye.z,gYaw=-1*Math.atan2(e.x,e.z),gSinYaw=Math.sin(gYaw),gCosYaw=Math.cos(gYaw);var o=Math.sqrt(e.x*e.x+e.z*e.z);gPitch=-1*(Math.atan2(o,e.y)-half_pi),gSinPitch=Math.sin(gPitch),gCosPitch=Math.cos(gPitch)}function eye(e,o,i){gEye.x=e,gEye.y=o,gEye.z=i,update(),mgraphics.redraw();var t=cartopol3D(gEye.x,gEye.y,gEye.z);outlet(1,"orbit3D",t.x,t.y,t.z)}function poi(e,o,i){gPoi.x=e,gPoi.y=o,gPoi.z=i,update(),mgraphics.redraw()}function fov(e){gFov=clip(e,1e-4,179),gFov2=piwrap(.5*e*degtorad),gFov2V=1/Math.tan(gFov2),gFov2V=Math.atan2(gRatio,gFov2V),gProjectionDistance=gSize.w/Math.tan(gFov2),mgraphics.redraw(),outlet(1,"fov",gFov)}function clipping_range(e,o){var i=e,t=o;i<=t?(gRange.x=i,gRange.y=t):(gRange.x=t,gRange.y=i),update()}function viewport_size(e,o){gSize.x=e,gSize.y=o,gSize.w=.5*e,gRatio=gSize.y/gSize.x,gSize.h=gSize.w*gRatio,gProjectionDistance=gSize.w/Math.tan(gFov2),update()}function angle_mode(e){gMode=0==e?0:1,update()}function translate_view3D(e,o,i){viewTranslate3D.x=e,viewTranslate3D.y=o,viewTranslate3D.z=i,update(),mgraphics.redraw(),outlet(1,"translateview3D",viewTranslate.x,viewTranslate.y,viewTranslate.z)}function orbit3D(e,o,i){gOrbit.x=e,gOrbit.y=clip(o,-89.999,89.999),gOrbit.z=Math.max(i,.01);var t=poltocar3D(gOrbit.x,gOrbit.y,gOrbit.z);eye(t.x,t.y,t.z),update(),mgraphics.redraw(),outlet(1,"orbit3D",gOrbit.x,gOrbit.y,gOrbit.z)}function reset_3D_view(){gEye.x=gEye.y=0,gEye.z=-2,gPoi.x=gPoi.y=gPoi.z=0,gViewCoords.x=gViewCoords.y=gViewCoords.z=0,gPitch=0,gSinPitch=0,gCosPitch=1,gYaw=0,gSinYaw=0,gCosYaw=1,gRoll=0,gSinRoll=0,gCosRoll=1,gSize.x=480,gSize.y=360,gSize.w=160,gSize.h=120,gRatio=gSize.y/gSize.x,gFov2=piwrap(.5*(gFov=60)*degtorad),gFov2V=1/Math.tan(gFov2),gFov2V=Math.atan2(gRatio,gFov2V),gProjectionDistance=gSize.w/Math.tan(gFov2),gRange.x=1e-4,gRange.y=1e3,gMode=0}function piwrap(e){var o=e>=0?e+pi:e-pi;return e-Math.floor(o*divide_two_pi)*two_pi}function poltocar3D(e,o,i){var t=new Point,n=piwrap(e*degtorad),l=-1*piwrap(o*degtorad)+half_pi,r=Math.sin(n),a=Math.cos(n),c=Math.sin(l),s=Math.cos(l);return t.x=r*i*c,t.y=s*i,t.z=a*i*c,t}function cartopol3D(e,o,i){var t=new Point,n=new Point;return n.x=e*e,n.y=o*o,n.z=i*i,t.x=Math.atan2(e,i),t.y=-1*(Math.atan2(Math.sqrt(n.x+n.z),o)-half_pi),t.z=Math.sqrt(n.x+n.y+n.z),t}function scene_rotation(e,o,i){var t=new Array(3);t[0]=e*degtorad,t[1]=o*degtorad*-1,t[2]=i*degtorad+Math.PI,rotationQuat=euler_to_quat(t)}function quaternion_mult(e,o){var i=new Array;return i[0]=o[0]*e[0]-o[1]*e[1]-o[2]*e[2]-o[3]*e[3],i[1]=o[0]*e[1]+o[1]*e[0]-o[2]*e[3]+o[3]*e[2],i[2]=o[0]*e[2]+o[1]*e[3]+o[2]*e[0]-o[3]*e[1],i[3]=o[0]*e[3]-o[1]*e[2]+o[2]*e[1]+o[3]*e[0],i}function quaternion_normalise(e){var o=new Array(4),i=Math.sqrt(e[0]*e[0]+e[1]*e[1]+e[2]*e[2]+e[3]*e[3]);return o[0]=e[0]/i,o[1]=e[1]/i,o[2]=e[2]/i,o[3]=e[3]/i,o}function point_rotation_by_quaternion(e,o){var i=new Array(4),t=new Array(4);new Array(4);return t[0]=0,t[1]=e[0],t[2]=e[1],t[3]=e[2],i[0]=o[0],i[1]=-1*o[1],i[2]=-1*o[2],i[3]=-1*o[3],quaternion_mult(quaternion_mult(o,t),i)}function euler_to_quat(e){var o=new Array(4);const i=e[0],t=e[1],n=e[2];return s1=Math.sin(.5*i),s2=Math.sin(.5*t),s3=Math.sin(.5*n),c1=Math.cos(.5*i),c2=Math.cos(.5*t),c3=Math.cos(.5*n),s4=Math.sin(.5*(i+n)),s5=Math.sin(.5*(i-n)),c4=Math.cos(.5*(i+n)),c5=Math.cos(.5*(i-n)),o[3]=s1*s2*s3+c1*c2*c3,o[0]=-s1*s2*c3+s3*c1*c2,o[1]=s1*s3*c2+s2*c1*c3,o[2]=s1*c2*c3-s2*s3*c1,o}init(),bang.immediate=1,list.immediate=1,ondrag.immediate=1,ondblclick.immediate=1,calcPolyScale.immediate=1,calcPolyTranslate.immediate=1,insertPoint.immediate=1,linesegmentDistance.immediate=1,distance2d.immediate=1,distanceSquared2d.immediate=1,dot.immediate=1,angleBetween.immediate=1,angleTo.immediate=1,to_degrees.immediate=1,to_radians.immediate=1,clip.local=1,grid_snap.local=1,grid_snap.local=1,loadsaved.local=1,initial_view_offset.local=1,initial_view_scale.local=1,scale_polygon.immediate=1,translate_polygon.immediate=1,rotate_polygon.immediate=1,translate_view3D.private=1;